<?php
// Include your database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Base query
$sql = "SELECT coupon_id, coupon_code, amount, percentage, min_order_amount, usage_per_customer, expiry_date, auto_apply, maxamount,mode
        FROM coupon
        WHERE Delete_status = 0";

// Execute the query
$result = $conn->query($sql);

// Prepare the response
if ($result && $result->num_rows > 0) {
    $data = [];

    while ($row = $result->fetch_assoc()) {
        // Creating product_details array
        $product_details = [
            'id' => $row['coupon_id'],
            'couponcode' => $row['coupon_code'],
            'discountamount' => $row['amount'],
            'expirydate' => $row['expiry_date'],
            'percustomer' => $row['usage_per_customer'],
            'minorderamount' => $row['min_order_amount'],
            'mode' => $row['mode'],
            'autoapply' => $row['auto_apply']
        ];

        // Append product_details to the data array
        $data[] = $product_details;
    }

    // Return JSON response
    echo json_encode($data);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No coupon found']);
}
?>
